/**********Fei Wang**************************************/
// Goal: starting from node n1 to node n5 using a breadth-first search.

import java.util.*;
import java.io.*;
// Node information.
class getSuccessor {
  String from;
  String to;
  int distance;
  boolean skip; // used in backtracking
  getSuccessor(String f, String t, int d) {
    from = f;
    to = t;
    distance = d;
    skip = false;
  }
}
class Breadth {
  final int MAX = 100;
  // This array holds the node information.
  getSuccessor nodes[] = new getSuccessor[MAX]; 
  int numNodes = 0; 
  Stack btStack = new Stack(); // backtrack stack
  public static void main(String args[])
  {
    String to, from;
    Breadth ob = new Breadth();
    BufferedReader br = new 
      BufferedReader(new InputStreamReader(System.in)); 
 
    ob.setup();  
    try { 
      System.out.println("*************** Welcome! ***************");
      System.out.println("*** This is an implementation of BFS algorithm ***");
      System.out.println("***** All Rights Reserved by Fei Wang. *****");
      System.out.print("From? ");
      from = br.readLine(); 
      System.out.print("To? ");
      to = br.readLine(); 
      ob.isnode(from, to);
      if(ob.btStack.size() != 0)
        ob.route(to);
    } catch (IOException exc) { 
      System.out.println("Error.");
    }
  }
  
  // Initialize the nodes database.
  void setup()
  {
    addNode("n1", "n2", 900);
    addNode("n2", "n4", 1000);
    addNode("n1", "n3", 500);
    addNode("n1", "n4", 1800);
    addNode("n3", "n6", 1700);
    addNode("n3", "n5", 2500);
    addNode("n3", "n2", 500);
    addNode("n4", "n8", 1000);
    addNode("n4", "n7", 1000);
    addNode("n7", "n5", 1500);
    addNode("n4", "n5", 1000);
  }
  
  // Put nodes into the database.
  void addNode(String from, String to, int dist)
  {  
    if(numNodes < MAX) {
      nodes[numNodes] =
        new getSuccessor(from, to, dist);
      numNodes++;
    }
    else System.out.println("Node database full.\n");
  }
  // Show the route and total distance.
  void route(String to)
  {
    Stack rev = new Stack();
    int dist = 0;
    getSuccessor f;
    int num = btStack.size();
    // Reverse the stack to display route.
    for(int i=0; i < num; i++) 
      rev.push(btStack.pop());
    for(int i=0; i < num; i++) {
      f = (getSuccessor) rev.pop();
      System.out.print(f.from + " to ");
      dist += f.distance;
    }
    System.out.println(to);
    System.out.println("Distance is " + dist);
  }
  /* If there is a node between from and to,
     return the distance of node;
     otherwise, return 0. */
  int match(String from, String to)
  {
    for(int i=numNodes-1; i > -1; i--) {
      if(nodes[i].from.equals(from) &&
         nodes[i].to.equals(to) &&
         !nodes[i].skip)
      {
        nodes[i].skip = true; // prevent reuse
        return nodes[i].distance;
      }
    }
    return 0; // not found 
  }
  
  // Find any connection by given from.
  getSuccessor find(String from)
  {
    for(int i=0; i < numNodes; i++) {
      if(nodes[i].from.equals(from) &&
         !nodes[i].skip)
      {
        getSuccessor f = new getSuccessor(nodes[i].from,
                             nodes[i].to,
                             nodes[i].distance);
        nodes[i].skip = true; // prevent reuse
        return f;
      }
    }
    return null;
  }
  
  /* If there is a route between from and to
     using breadth-first search. */
  void isnode(String from, String to)
  {
    int dist, dist2;
    getSuccessor f;
    // This stack is needed by the breadth-first search.
    Stack resetStck = new Stack();
    // See if at destination.
    dist = match(from, to);
    if(dist != 0) {
      btStack.push(new getSuccessor(from, to, dist));
      return;
    }
    /* It checks all connecting nodes
       from a specified node. */
    while((f = find(from)) != null) {
      resetStck.push(f);
      if((dist = match(f.to, to)) != 0) {
        resetStck.push(f.to);
        btStack.push(new getSuccessor(from, f.to, f.distance));
        btStack.push(new getSuccessor(f.to, to, dist));
        return;
      }
    }
    /* Resets the skip fields set by
       preceding while loop. */
    int i = resetStck.size();
    for(; i!=0; i--)
      resetSkip((getSuccessor) resetStck.pop());
    // Try another connection.
    f = find(from);
    if(f != null) {
      btStack.push(new getSuccessor(from, to, f.distance));
      isnode(f.to, to);
    }
    else if(btStack.size() > 0) {
      // Backtrack and try another connection.
      f = (getSuccessor) btStack.pop();
      isnode(f.from, f.to);
    }
  }
  // Reset skip field of specified node.
  void resetSkip(getSuccessor f) {
    for(int i=0; i< numNodes; i++)
      if(nodes[i].from.equals(f.from) &&
         nodes[i].to.equals(f.to))
           nodes[i].skip = false;
  }
}